library int3;

Uses
  Windows;

function Enigma_Plugin_About : PWideChar;
begin
  Enigma_Plugin_About := 'Enigma anti-debugger plugin - Int 3  Vladimir Sukhov 3 September 2008';
end;

function Enigma_Plugin_Description : PWideChar;
begin
  Enigma_Plugin_Description := 'This plugin creates a thread where is calling int 3 instruction.'#10#13 +
                               'Int 3 instruction uses with debuggers to set breakpoints to process.'#10#13 +
                               'Plugin continiously calls int 3 instruction and crashes all known debuggers.'#10#13 +
                               'Usually, when int 3 instruction executes, it occurs exception, but if process is'#10#13 +
                               'under debugger - no exception occurs.'#10#13 +
                               'If debugger is found then will be shown warning message and application terminates';
end;

const
  MB_ICONERROR = $00000010;
  THREAD_PRIORITY_NORMAL = 0;

  Title : pchar = 'Error';
  Text : pchar = 'Debugger is found on this machine!';

var
  ThreadID : cardinal;
  TimerID  : cardinal;

procedure ExitWithMessage; assembler;
asm
  // Clear some addresses in stack
  mov ecx, 5
  @clear_loop:
  dec ecx
  mov dword ptr [ecx * 4 + esp], 0
  cmp ecx, 0
  jnz @clear_loop
  // Parameter for ExitProcess
  push 0
  // Parameters for MessageBoxA
  push MB_ICONERROR
  push Title
  push Text
  push 0
  // Return address of MessageBox that points to ExitProcess
  lea eax, ExitProcess
  push eax
  jmp MessageBoxA
end;

procedure CheckDebugger;
begin
  // This plugin uses int 3 instruction to find a debugger
  // This function is placed into timer loop with 2 seconds delay and works all the time when
  // main application is working
  asm
    push offset @1
    push fs:[0]
    mov fs:[0], esp
    xor eax, eax
    @DoAccessViol:
    int 3
    call ExitWithMessage
    @1:
    mov eax, [esp+$C]
    mov [eax + $B8], offset @UnHandle
    xor eax, eax
    ret
    // Unhandle exception filter
    @UnHandle:
    pop fs:[0]
    add esp, 4
  end;
end;

function Thread_CallBack(AParam : cardinal) : cardinal; stdcall;
begin
  while true do
  begin
    CheckDebugger;
    // Wait 2 seconds and check debugger again!
    Sleep(2000);
  end;
end;

procedure Timer_CallBack(hwnd : cardinal; uMsg, idEvent, dwTime : cardinal); stdcall;
var
  context : TContext;
begin
  if idEvent <> TimerID then Exit;
  if GetThreadContext(ThreadID, context) then
  begin
    // Trick against suspending thread
    ResumeThread(ThreadID);
    // Trick against set lowest prioroty to thread
    SetThreadPriority(ThreadID, THREAD_PRIORITY_NORMAL);
  end else
  begin
    // if GetThreadTimes fails it means that thread was killed
    // so, exit with a debugger message
    KillTimer(0, TimerID);
    ExitWithMessage;
  end;
end;

procedure Enigma_Plugin_OnInit;
var
  cthread : cardinal;
begin
  CheckDebugger;
  // Create thread that will looking for debugger
  ThreadID := CreateThread(nil, 0, @Thread_CallBack, nil, 0, cthread);
  if ThreadID <> 0 then
  begin
    // Create a timer that will looking for thread
    TimerID := SetTimer(0, 1, 2000, @Timer_CallBack);
  end;
end;

exports
  Enigma_Plugin_About,
  Enigma_Plugin_Description,
  Enigma_Plugin_OnInit;

begin
end.


